/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.VWResolver;
import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioWorkflowDefinition;
import filenet.sim.api.VWXMLErrorHandler;
import filenet.sim.api.VWXML_CUR_parser;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.base.XMLHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class VWScenarioXMLHandler {
    protected static final String API_XML_VERSION = "1.0";
    protected static final String DTDNAME_CUR = "scenario2.dtd";
    protected static final String XMLPreamble = "<?xml version='1.0' encoding='UTF-8'?>\n<!DOCTYPE Scenario SYSTEM \"scenario2.dtd\">\n<Scenario ApiVersion=\"1.0\"\n";
    protected static final String XPDLPreamble = "<Scenario ApiVersion=\"1.0\"\n";
    protected static final SimpleDateFormat dateFormatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss aa", Locale.US);
    private static Date m_lastTime = new Date();
    protected static final String BASE_INDENT = "";
    protected static final String BUMP_INDENT = "\t";
    protected static final String WORKFLOWDEFS_INDENT = "\t";
    protected static final String RESOURCEDEF_INDENT = "\t";
    protected static final String ACTIVITYDEFS_INDENT = "\t";
    protected static final String ARRIVALDEFS_INDENT = "\t";
    protected static final String OPTIONS_INDENT = "\t";
    protected static final String CONFIG_INDENT = "\t";

    protected static VWScenarioDefinition[] parseXPDLScenarioCollection(Object parsedObject) throws VWException, IOException, SAXException, ParseException {
        if (parsedObject != null && parsedObject instanceof Element) {
            Element scenarioDefinitionsElement = (Element)parsedObject;
            return VWXML_CUR_parser.parseXPDLScenarioCollection(scenarioDefinitionsElement);
        }
        return null;
    }

    protected static VWScenarioDefinition parseXMLScenario(BufferedReader inputXML, boolean validate) throws IOException, SAXException, VWException, NumberFormatException, ParseException {
        Document doc = VWScenarioXMLHandler.parseXML(inputXML);
        Element ele = doc.getDocumentElement();
        ele.normalize();
        String verStr = ele.getAttribute("ApiVersion");
        if (verStr == null || verStr.equals(BASE_INDENT)) {
            return null;
        }
        if (verStr.equals(API_XML_VERSION)) {
            return VWXML_CUR_parser.parseXMLScenario(ele);
        }
        throw new VWException("sim.api.VWScenarioXMLHandler.VWBadXMLFileVersion", "The XML file contains an ApiVersion attribute, {0}, Which cannot be parsed by this version of the scenario API.", verStr);
    }

    protected static void generateRuntimeWorkflows(VWScenarioDefinition scenario, VWSession session) throws VWException {
        try {
            VWScenarioWorkflowDefinition[] scenarioWFs = scenario.getWorkflows();
            if (scenarioWFs == null) {
                return;
            }
            String serviceName = session.getServerName();
            String region = BASE_INDENT + session.getIsolatedRegion();
            for (int i = 0; i < scenarioWFs.length; ++i) {
                NamedNodeMap attributes;
                VWWorkflowDefinition authoredWorkflow = scenarioWFs[i].getWorkflowDefinition();
                BufferedReader reader = new BufferedReader(new StringReader(authoredWorkflow.AsXMLString()));
                Document wfDocument = VWScenarioXMLHandler.parseXML(reader);
                Element rootElement = wfDocument.getDocumentElement();
                Node runtimeIdNode = VWScenarioXMLHandler.getNodeNamed(rootElement, "WFRuntimeId");
                if (runtimeIdNode == null) {
                    runtimeIdNode = wfDocument.createElement("WFRuntimeId");
                    rootElement.insertBefore(runtimeIdNode, rootElement.getFirstChild());
                }
                if ((attributes = runtimeIdNode.getAttributes()) != null) {
                    Attr attrNode = wfDocument.createAttribute("ServiceName");
                    attrNode.setNodeValue(serviceName);
                    attributes.setNamedItem(attrNode);
                    attrNode = wfDocument.createAttribute("IsolatedRegion");
                    attrNode.setNodeValue(region);
                    attributes.setNamedItem(attrNode);
                    SimpleDateFormat dateFormatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
                    attrNode = wfDocument.createAttribute("IRTimeStamp");
                    attrNode.setNodeValue(dateFormatter.format(new Date()));
                    attributes.setNamedItem(attrNode);
                    String workClassId = BASE_INDENT + i;
                    attrNode = wfDocument.createAttribute("WorkClassId");
                    attrNode.setNodeValue(workClassId);
                    attributes.setNamedItem(attrNode);
                    String workClassRevision = "1";
                    attrNode = wfDocument.createAttribute("WCRevision");
                    attrNode.setNodeValue(workClassRevision);
                    attributes.setNamedItem(attrNode);
                    String id = InetAddress.getLocalHost().getHostAddress() + "::" + VWScenarioXMLHandler.getUniqueTime().getTime() + "::" + (int)(Math.random() * 1.0E9);
                    attrNode = wfDocument.createAttribute("Id");
                    attrNode.setNodeValue(id);
                    attributes.setNamedItem(attrNode);
                }
                int maxMapId = -1;
                VWMapDefinition[] maps = authoredWorkflow.getMaps();
                for (int j = 0; j < maps.length; ++j) {
                    int mapId = maps[j].getMapId();
                    if (mapId <= maxMapId) continue;
                    maxMapId = mapId;
                }
                List mapNodes = VWScenarioXMLHandler.getNodesNamed(rootElement, "Map");
                for (Element mapElement : mapNodes) {
                    if (mapElement.hasAttribute("MapId") && mapElement.getAttribute("MapId").compareTo("-1") != 0) continue;
                    String mapName = mapElement.getAttribute("Name");
                    int mapId = -1;
                    mapId = mapName.compareTo("Workflow") == 0 ? -2 : (mapName.compareTo("Terminate") == 0 ? -3 : (mapName.compareTo("Malfunction") == 0 ? -4 : (mapName.compareTo("QueueAssertionViolation") == 0 ? -5 : (mapName.compareTo("Recovery") == 0 ? -6 : (mapName.compareTo("Tracker") == 0 ? -7 : ++maxMapId)))));
                    mapElement.setAttribute("MapId", Integer.toString(mapId));
                }
                VWWorkflowDefinition wf = VWXMLHandler.parseXMLWorkFlow(rootElement);
                wf.convertAllRouteConditionsToValidExpressions();
                scenarioWFs[i].setGeneratedWorkflowDefinition(wf);
            }
        }
        catch (Exception e) {
            throw new VWException("vw.api.VWScenarioXMLHandler.RuntimeIdGerationError", "{0}", e.getLocalizedMessage());
        }
    }

    private static final synchronized Date getUniqueTime() {
        Date currentTime = new Date();
        m_lastTime = m_lastTime.equals(currentTime) ? new Date(currentTime.getTime() + 1000L) : currentTime;
        return m_lastTime;
    }

    protected static Date convertStringToDate(String stringDate) throws ParseException {
        return dateFormatter.parse(stringDate);
    }

    protected static String convertDateToString(Date date) {
        return dateFormatter.format(date);
    }

    public static String convertTimeValue(int time) throws VWException {
        if (time < 0 || time > 86400) {
            throw new VWException("sim.api.VWScenarioXMLHandler.InvalidTimeSecondsValue", "The time value {0} is invalid.", new Integer(time));
        }
        int hours = time / 3600;
        hours = hours > 0 ? (hours > 12 ? hours - 12 : hours) : 12;
        int minutes = time % 3600 / 60;
        int seconds = time % 3600 % 60;
        String aa = time / 3600 < 12 ? "AM" : "PM";
        return (hours < 10 ? "0" + hours : BASE_INDENT + hours) + ":" + (minutes < 10 ? "0" + minutes : BASE_INDENT + minutes) + ":" + (seconds < 10 ? "0" + seconds : BASE_INDENT + seconds) + " " + aa;
    }

    public static int convertTimeValue(String time) {
        StringTokenizer tokens = new StringTokenizer(time, ":", false);
        int hours = Integer.parseInt(tokens.nextToken());
        int minutes = Integer.parseInt(tokens.nextToken());
        String tmp = tokens.nextToken();
        int seconds = Integer.parseInt(tmp.substring(0, 2));
        boolean pm = tmp.substring(3).equals("PM");
        if (pm) {
            if (hours != 12) {
                hours += 12;
            }
        } else if (hours == 12) {
            hours = 0;
        }
        return hours * 3600 + minutes * 60 + seconds;
    }

    protected static String getXMLString(Node aNode) {
        NodeList childNodes = aNode.getChildNodes();
        if (childNodes == null) {
            return null;
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 3) continue;
            return childNode.getNodeValue();
        }
        return null;
    }

    protected static String toXMLString(String buf) {
        return XMLHelper.toXMLString(buf);
    }

    protected static String toXMLString(Object theValue) throws VWException {
        if (theValue == null) {
            return BASE_INDENT;
        }
        String valueString = null;
        int fieldType = VWFieldType.getVWFieldType(theValue);
        boolean isArray = theValue.getClass().isArray();
        if (isArray) {
            valueString = null;
        } else {
            valueString = fieldType == 16 ? VWScenarioXMLHandler.convertDateToString((Date)theValue) : theValue.toString();
            if (fieldType == 16 || fieldType == 32 || fieldType == 64) {
                valueString = "\"" + valueString + "\"";
            }
        }
        return VWScenarioXMLHandler.toXMLString(valueString);
    }

    protected static String booleanToString(boolean val) {
        if (val) {
            return "true";
        }
        return "false";
    }

    protected static boolean stringToBoolean(String val) throws VWException {
        if (val == null) {
            return false;
        }
        if (val.equals("true")) {
            return true;
        }
        if (val.equals("false")) {
            return false;
        }
        throw new VWException("vw.api.VWBooleanTypeBadString", "String form of the boolean type is invalid: {0}", val);
    }

    protected static Node getNodeNamed(Node parentNode, String name) {
        if (parentNode == null) {
            return null;
        }
        NodeList nodeList = parentNode.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (name.compareTo(node.getNodeName()) != 0) continue;
                return node;
            }
        }
        return null;
    }

    protected static List getNodesNamed(Node parentNode, String name) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList nodeList = parentNode.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (name.compareTo(node.getNodeName()) != 0) continue;
                list.add(node);
            }
        }
        return list;
    }

    protected static Element getFirstChildElement(Node parentNode) {
        Element element = null;
        NodeList nodeList = parentNode.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() != 1) continue;
                element = (Element)nodeList.item(i);
                break;
            }
        }
        return element;
    }

    public static Document parseScenarioDocumentViaDOM(InputSource inSource) throws IOException, SAXException, VWException, NumberFormatException {
        Document doc = XMLHelper.parseDocumentViaDOM(inSource, new VWResolver(), new VWXMLErrorHandler(), false);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document parseXML(BufferedReader inputXML) throws IOException, SAXException, VWException, NumberFormatException, ParseException {
        Document document;
        block5: {
            try {
                document = VWScenarioXMLHandler.parseScenarioDocumentViaDOM(new InputSource(inputXML));
                Object var3_2 = null;
                if (inputXML == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var3_3 = null;
                    if (inputXML == null) break block6;
                    try {
                        inputXML.close();
                    }
                    catch (Exception e) {}
                }
                throw throwable;
            }
            try {
                inputXML.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return document;
    }
}

